% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{lexicons}
\alias{lexicons}
\title{Built-in lexicons}
\format{A list with all built-in lexicons, appropriately named as \code{"NAME_language(_tr)"} .}
\source{
\href{http://www.lirmm.fr/~abdaoui/FEEL}{FEEL lexicon}

\href{http://www.wjh.harvard.edu/~inquirer/spreadsheet_guide.htm}{GI lexicon}

\href{https://study.sagepub.com/sites/default/files/1\%20Henry\%202008_0.pdf}{HENRY lexicon}

\href{https://www3.nd.edu/~mcdonald/Word_Lists.html}{LM lexicon}
}
\usage{
data("lexicons")
}
\description{
A list containing all built-in lexicons as a \code{data.table} with two columns: a \code{x} column with the words, and a
\code{y} column with the polarities. The list element names incorporate consecutively the name and language, and
\code{"_tr"} as suffix if the lexicon is translated. The lexicons are in the format required for further sentiment analysis.
The built-in lexicons are the following:

\itemize{
  \item FEEL_eng_tr (FEEL: French Expanded Emotion Lexicon)
  \item FEEL_fr
  \item FEEL_nl_tr
  \item GI_eng (GI: General Inquirer, i.e. Harvard IV-4 combined with Laswell)
  \item GI_fr_tr
  \item GI_nl_tr
  \item HENRY_eng (HENRY: Henry)
  \item HENRY_fr_tr
  \item HENRY_nl_tr
  \item LM_eng (LM: Loughran and McDonald)
  \item LM_fr_tr
  \item LM_nl_tr
}
}
\examples{
lexicons[c("FEEL_eng_tr", "LM_eng")]
}
\keyword{datasets}
