% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{fill_measures}
\alias{fill_measures}
\title{Add and fill missing dates}
\usage{
fill_measures(sentomeasures, fill = "zero")
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{fill}{an element of \code{c("zero", "latest", NA)}; the first and last assume missing dates represent zero sentiment,
the second assumes missing dates represent constant sentiment.}
}
\value{
A modified \code{sentomeasures} object.
}
\description{
Adds missing dates between earliest and latest date of a \code{sentomeasures} object, such that time series
is continuous date-wise. Fills in these dates with either 0, the respective latest non-missing value or \code{NA}.
}
\examples{
data("usnews", package = "sentometrics")
data("lexicons", package = "sentometrics")
data("valence", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# fill measures
f1 <- fill_measures(sentomeasures)
f2 <- fill_measures(sentomeasures, fill = "latest")
f3 <- fill_measures(sentomeasures, fill = NA)

}
\author{
Samuel Borms
}
