% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentocorpus.R
\name{corpus_summarize}
\alias{corpus_summarize}
\title{Summarize the sento_corpus object}
\usage{
corpus_summarize(x, by = "day", features = NULL)
}
\arguments{
\item{x}{is a \code{sento_corpus} object created with \code{\link{sento_corpus}}}

\item{by}{a single \code{character} vector to specify the frequency time interval over which the statistics
need to be calculated.}

\item{features}{a \code{character} vector that can be used to select a subset of the features to be analysed.}
}
\value{
returns a \code{list} containing:
\item{stats}{a \code{data.table} with statistics about the number of documents, total, average, minimum and maximum
number of tokens and the number of texts per features for each date.}
\item{plots}{a \code{list} with three plots representing the above statistics.}
}
\description{
Summarizes the \code{sento_corpus} object and returns insights about features and tokens over time.
}
\details{
This function summarizes the \code{sento_corpus} object by generating statistics about features and tokens over
time. The insights can be narrowed down to a chosen set of metadata features. The same tokenization as in the
sentiment calculation in \code{\link{compute_sentiment}} is used.
}
\examples{
data("usnews", package = "sentometrics")

corpus <- sento_corpus(usnews)

# summary of corpus by day
summary1 <- corpus_summarize(corpus)

# summary of corpus by month
summary2 <- corpus_summarize(corpus, by = "month")

}
\author{
Jeroen Van Pelt, Samuel Borms, Andres Algaba
}
