% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeSeries.R
\name{sentiment_series}
\alias{sentiment_series}
\title{Compute a sentiment time series}
\usage{
sentiment_series(
  x,
  period = c("year", "quarter", "month", "day"),
  rolling_window = 1,
  scale = TRUE,
  scaling_period = c("1900-01-01", "2099-12-31"),
  as.xts = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}} model populated with internal dates
and/or internal sentiment.}

\item{period}{the sampling period within which the sentiment of documents
will be averaged. \code{period = "identity"} is a special case that will return
document-level variables before the aggregation happens. Useful to rapidly
compute topical sentiment at the document level.}

\item{rolling_window}{if greater than 1, determines the rolling window to
compute a moving average of sentiment. The rolling window is based on the
period unit and rely on actual dates (i.e, is not affected by unequally
spaced data points).}

\item{scale}{if \code{TRUE}, the resulting time series will be scaled to a mean of
zero and a standard deviation of 1. This argument also has the side effect
of attaching scaled sentiment values as \emph{docvars} to the input object with
the \verb{_scaled} suffix.}

\item{scaling_period}{the date range over which the scaling should be
applied. Particularly useful to normalize only the beginning of the time
series.}

\item{as.xts}{if \code{TRUE}, returns an \link[xts:xts]{xts::xts} object. Otherwise, returns a
data.frame.}

\item{...}{other arguments passed on to \code{\link[zoo:rollapply]{zoo::rollapply()}} or \code{\link[=mean]{mean()}} and
\code{\link[=sd]{sd()}}.}
}
\value{
A time series of sentiment, stored as an \link[xts:xts]{xts::xts} or
data.frame.
}
\description{
Compute a sentiment time series based on the internal sentiment
and dates of a \code{sentopicmodel}. The time series computation supports
multiple sampling period and optionally allow computing a moving average.
}
\examples{
lda <- LDA(ECB_press_conferences_tokens)
series <- sentiment_series(lda, period = "month")

# JST and rJST models can use computed sentiment from the sentiment layer,
# but the model must be estimated first.
rjst <- rJST(ECB_press_conferences_tokens, lexicon = LoughranMcDonald)
sentiment_series(rjst)

sentopics_sentiment(rjst) <- NULL ## remove existing sentiment
rjst <- grow(rjst, 10) ## estimating the model is then needed
sentiment_series(rjst)

# note the presence of both raw and scaled sentiment values
# in the initial object
sentopics_sentiment(lda)
sentopics_sentiment(rjst)
}
\seealso{
sentopics_sentiment sentopics_date

Other series functions: 
\code{\link{proportion_topics}()},
\code{\link{sentiment_breakdown}()},
\code{\link{sentiment_topics}()}
}
\concept{series functions}
