% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{get_ECB_speeches}
\alias{get_ECB_speeches}
\title{Download and pre-process speeches from the European Central Bank}
\usage{
get_ECB_speeches(
  filter_english = TRUE,
  clean_footnotes = TRUE,
  compute_sentiment = TRUE,
  tokenize_w_POS = FALSE
)
}
\arguments{
\item{filter_english}{if \code{TRUE}, attempts to select English speeches only
using \code{\link[textcat:textcat]{textcat::textcat()}}.}

\item{clean_footnotes}{if \code{TRUE}, attempts to clean footnotes from speeches
texts using some regex patterns.}

\item{compute_sentiment}{if \code{TRUE}, computes the sentiment of each speech
using \code{\link[sentometrics:compute_sentiment]{sentometrics::compute_sentiment()}} with the the Loughran & McDonald
lexicon.}

\item{tokenize_w_POS}{if \code{TRUE}, tokenizes and apply Part-Of-Speech tagging
with \code{\link[spacyr:spacy_parse]{spacyr::spacy_parse()}}. Nouns, adjectives and proper nouns are then
extracted from the parsed speeches to form a \code{tokens} object.}
}
\value{
Depending on the arguments, returns either a data.frame or a
\link[quanteda:tokens]{quanteda::tokens} object containing speeches of the ECB.
}
\description{
This helper function automatically retrieve the full data set of
speeches made available by the ECB. In addition, it implements a number of
pre-processing steps that may be turned on or off as needed.
}
