% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden_paths.R
\name{hidden_paths}
\alias{hidden_paths}
\title{Most Probable Paths of Hidden States}
\usage{
hidden_paths(model)
}
\arguments{
\item{model}{Hidden Markov model of class \code{hmm} or
mixture HMM of class \code{mhmm}.}
}
\value{
Most probable paths of hidden states as an \code{stslist} object
(see \code{\link{seqdef}}). The log-probability included as an attribute \code{log_prob}.
}
\description{
Function \code{hidden_paths} computes the most probable path of
hidden states of a (mixture) hidden Markov model given the observed sequences.
}
\examples{

mpp <- hidden_paths(hmm_biofam)
ssplot(mpp, type = "I", tlim = 1:100)

# because the model structure is so sparse that the posterior probabilities are 
# mostly peaked to single state at each time point, the joint probability of 
# observations and most probable paths of hidden states is almost identical to 
# log-likelihood:

sum(attr(mpp, "log_prob"))
logLik(hmm_biofam)

}
\seealso{
\code{\link{hmm_biofam}} for information on the model used in the example;
  and \code{\link{seqIplot}}, \code{\link{ssplot}}, or \code{\link{mssplot}}
  for plotting the most probable paths of hidden states.
}

