% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package.R
\docType{package}
\name{seqR-package}
\alias{seqR-package}
\alias{seqR}
\title{seqR: Fast and Comprehensive K-Mer Counting Package}
\description{
The \code{seqR} package provides in-memory, probabilistic,
highly-optimized, and multi-threaded implementation of k-mer counting.
}
\examples{
# Load exemplary sequences
data(CsgA)

# Counting 1-mers (amino acid composition)
count_kmers(
    CsgA,
    k = 1,
    batch_size = 1)   


# Counting 1-mers and 2-mers
count_multimers(
    CsgA,
    k_vector = c(1, 2),
    batch_size = 1)
}
\author{
Jadwiga Słowik
}
