% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation_powerset.R
\name{powerset}
\alias{powerset}
\title{Calculate a Set's Powerset}
\usage{
powerset(x, simplify = FALSE)
}
\arguments{
\item{x}{\link{Set}}

\item{simplify}{logical, if \code{TRUE} then tries to simplify the result to a \code{Set} otherwise
creates an object of class \link{PowersetSet}.}
}
\value{
\link{Set}
}
\description{
Calculates and returns the powerset of a Set.
}
\details{
A powerset of a set, S, is defined as the set of all subsets of S, including S itself
and the empty set.
}
\examples{
# simplify = FALSE is default
powerset(Set$new(1, 2))
powerset(Set$new(1, 2), simplify = TRUE)

# powerset of intervals
powerset(Interval$new())

# powerset of powersets
powerset(powerset(Reals$new()))
powerset(powerset(Reals$new()))$properties$cardinality
}
\seealso{
Other operators: 
\code{\link{setcomplement}()},
\code{\link{setintersect}()},
\code{\link{setpower}()},
\code{\link{setproduct}()},
\code{\link{setsymdiff}()},
\code{\link{setunion}()}
}
\concept{operators}
