% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-collection.R
\name{Collection}
\alias{Collection}
\title{R6 Class representing a Collection of objects}
\description{
R6 Class representing a resource for managing collections.
Wrapper for Seven Bridges pageable resources.
Among the actual collection items it contains information regarding
the total number of entries available on the server and
resource API request URL (href).
}
\examples{

## ------------------------------------------------
## Method `Collection$print`
## ------------------------------------------------

\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Print collection object
 collection_object$print()
}


## ------------------------------------------------
## Method `Collection$next_page`
## ------------------------------------------------

\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get next page of collection results
 collection_object$next_page()
}


## ------------------------------------------------
## Method `Collection$prev_page`
## ------------------------------------------------

\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get previous page of collection results
 collection_object$prev_page()
}


## ------------------------------------------------
## Method `Collection$all`
## ------------------------------------------------

\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get all results of collection
 collection_object$all()
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{href}}{API request URL.}

\item{\code{items}}{Items returned in API response.}

\item{\code{links}}{List of links (hrefs) for next and/or previous page
resources.}

\item{\code{total}}{Total number of items available on the server.}

\item{\code{response}}{Raw API response.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Collection-new}{\code{Collection$new()}}
\item \href{#method-Collection-print}{\code{Collection$print()}}
\item \href{#method-Collection-next_page}{\code{Collection$next_page()}}
\item \href{#method-Collection-prev_page}{\code{Collection$prev_page()}}
\item \href{#method-Collection-all}{\code{Collection$all()}}
\item \href{#method-Collection-clone}{\code{Collection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-new}{}}}
\subsection{Method \code{new()}}{
Create a new Collection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$new(
  href = NA,
  items = NA,
  links = NA,
  total = NA,
  response = NA,
  auth = NA
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{href}}{API request URL.}

\item{\code{items}}{Items returned in API response.}

\item{\code{links}}{List of links (hrefs) for next and/or previous page
resources.}

\item{\code{total}}{Total number of items available on the server.}

\item{\code{response}}{Raw API response.}

\item{\code{auth}}{Seven Bridges Authentication object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-print"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-print}{}}}
\subsection{Method \code{print()}}{
Print method for Collection class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$print(n = 10)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of items to print in console.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Print collection object
 collection_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-next_page"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-next_page}{}}}
\subsection{Method \code{next_page()}}{
Return next page of results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$next_page(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'advanced_access', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get next page of collection results
 collection_object$next_page()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-prev_page"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-prev_page}{}}}
\subsection{Method \code{prev_page()}}{
Return previous page of results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$prev_page(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'advanced_access', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get previous page of collection results
 collection_object$prev_page()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-all"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-all}{}}}
\subsection{Method \code{all()}}{
Fetches all available items by iterating through all pages.
Please be aware of the API rate limit for your request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$all(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'advanced_access', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when collection object is requested
 collection_object <- Collection$new(
                                   href = x$href,
                                   items = x$items,
                                   links = x$links,
                                   total = x$total,
                                   auth = auth,
                                   response = attr(x, "response")
                                 )

 # Get all results of collection
 collection_object$all()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Collection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Collection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Collection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
