% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-billing.R
\name{Billing}
\alias{Billing}
\title{R6 Class representing billing information.}
\description{
R6 Class representing a central resource for managing billing groups.
}
\details{
This is main object for Billing
}
\examples{

## ------------------------------------------------
## Method `Billing$print`
## ------------------------------------------------

\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print billing group
 billing_object$print()
}


## ------------------------------------------------
## Method `Billing$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload billing group
 billing_object$reload()
}


## ------------------------------------------------
## Method `Billing$analysis_breakdown`
## ------------------------------------------------

\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get analysis breakdown
 billing_object$analysis_breakdown()
}


## ------------------------------------------------
## Method `Billing$storage_breakdown`
## ------------------------------------------------

\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get storage breakdown
 billing_object$storage_breakdown()
}


## ------------------------------------------------
## Method `Billing$egress_breakdown`
## ------------------------------------------------

\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get egress breakdown
 billing_object$egress_breakdown()
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Billing}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{Billing group identifier.}

\item{\code{owner}}{Username of the user that owns the billing group.}

\item{\code{name}}{Billing group name.}

\item{\code{type}}{Billing group type}

\item{\code{pending}}{Billing group approval status.}

\item{\code{disabled}}{Indicator of whether the billing group is disabled.}

\item{\code{balance}}{Billing group balance.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Billing-new}{\code{Billing$new()}}
\item \href{#method-Billing-print}{\code{Billing$print()}}
\item \href{#method-Billing-reload}{\code{Billing$reload()}}
\item \href{#method-Billing-analysis_breakdown}{\code{Billing$analysis_breakdown()}}
\item \href{#method-Billing-storage_breakdown}{\code{Billing$storage_breakdown()}}
\item \href{#method-Billing-egress_breakdown}{\code{Billing$egress_breakdown()}}
\item \href{#method-Billing-clone}{\code{Billing$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-new"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-new}{}}}
\subsection{Method \code{new()}}{
Create a new Billing object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Billing object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-print"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-print}{}}}
\subsection{Method \code{print()}}{
Print billing group information as a bullet list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print billing group
 billing_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Billing group object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'limit', 'offset', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Billing}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload billing group
 billing_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-analysis_breakdown"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-analysis_breakdown}{}}}
\subsection{Method \code{analysis_breakdown()}}{
Method for getting a analysis breakdown for a billing group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$analysis_breakdown(
  date_from = NULL,
  date_to = NULL,
  invoice = NULL,
  fields = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date_from}}{A string representing the starting date for retrieving
transactions analysis in the following format: mm-dd-yyyy.}

\item{\code{date_to}}{A string representing the ending date for retrieving
transactions analysis in the following format: mm-dd-yyyy.}

\item{\code{invoice}}{A string representing invoice ID or Invoice object to
show a breakdown for the specific invoice. If omitted, the current
spending breakdown is returned.}

\item{\code{fields}}{Selector specifying a subset of fields to include in the
response.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get analysis breakdown
 billing_object$analysis_breakdown()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-storage_breakdown"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-storage_breakdown}{}}}
\subsection{Method \code{storage_breakdown()}}{
Method for getting a storage breakdown for a billing group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$storage_breakdown(
  date_from = NULL,
  date_to = NULL,
  invoice = NULL,
  fields = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date_from}}{A string representing the starting date for retrieving
storage analysis in the following format: mm-dd-yyyy.}

\item{\code{date_to}}{A string representing the ending date for retrieving
storage analysis in the following format: mm-dd-yyyy.}

\item{\code{invoice}}{A string representing invoice ID or Invoice object to
show a breakdown for the specific invoice. If omitted, the current
spending breakdown is returned.}

\item{\code{fields}}{Selector specifying a subset of fields to include in the
response.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get storage breakdown
 billing_object$storage_breakdown()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-egress_breakdown"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-egress_breakdown}{}}}
\subsection{Method \code{egress_breakdown()}}{
Method for getting a egress breakdown for a billing group.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$egress_breakdown(
  date_from = NULL,
  date_to = NULL,
  invoice = NULL,
  fields = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date_from}}{A string representing the starting date for retrieving
egress analysis in the following format: mm-dd-yyyy.}

\item{\code{date_to}}{A string representing the ending date for retrieving
egress analysis in the following format: mm-dd-yyyy.}

\item{\code{invoice}}{A string representing invoice ID or Invoice object to
show a breakdown for the specific invoice. If omitted, the current
spending breakdown is returned.}

\item{\code{fields}}{Selector specifying a subset of fields to include in the
response.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# x is API response when billing group is requested
 billing_object <- Billing$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get egress breakdown
 billing_object$egress_breakdown()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Billing-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Billing-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Billing$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
