% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspot_change.R
\name{hotspot_change}
\alias{hotspot_change}
\title{Identify change in hotspots over time}
\usage{
hotspot_change(
  data,
  time = NULL,
  boundary = NULL,
  groups = NULL,
  cell_size = NULL,
  grid_type = "rect",
  grid = NULL,
  quiet = FALSE
)
}
\arguments{
\item{data}{\code{\link[sf]{sf}} data frame containing points.}

\item{time}{Name of the column in \code{data} containing \code{Date} or
\code{POSIXt} values representing the date associated with each point.
Ignored if \code{groups} is not \code{NULL}. If this argument is
\code{NULL} and \code{data} contains a single column of \code{Date} or
\code{POSIXt} values, that column will be used automatically.}

\item{boundary}{A single \code{Date} or \code{POSIXt} value representing the
point after which points should be treated as having occurred in the second
time period. See 'Details'.}

\item{groups}{Name of a column in \code{data} containing exactly two unique
non-missing values, which will be used to identify whether each row should
be counted in the first (before) or second (after) groups. Which groups to
use will be determined by calling \code{sort(unique(groups))}. If
\code{groups} is not a factor, a message will be printed confirming which
value has been used for which group. See 'Details'.}

\item{cell_size}{\code{numeric} value specifying the size of each equally
spaced grid cell, using the same units (metres, degrees, etc.) as used in
the \code{sf} data frame given in the \code{data} argument. Ignored if
\code{grid} is not \code{NULL}. If this argument and \code{grid} are
\code{NULL} (the default), the cell size will be calculated automatically
(see Details).}

\item{grid_type}{\code{character} specifying whether the grid should be made
up of squares (\code{"rect"}, the default) or hexagons (\code{"hex"}).
Ignored if \code{grid} is not \code{NULL}.}

\item{grid}{\code{\link[sf]{sf}} data frame containing points containing
polygons, which will be used as the grid for which counts are made.}

\item{quiet}{if set to \code{TRUE}, messages reporting the values of any
parameters set automatically will be suppressed. The default is
\code{FALSE}.}
}
\value{
An \code{\link[sf]{sf}} tibble of regular grid cells with
corresponding hot-spot classifications for each cell. This can be plotted
using \code{\link{autoplot}}.
}
\description{
Identify change in the number of points (typically representing events)
between two periods (before and after a specified date) or in two groups
(e.g. on weekdays or at weekends).
}
\details{
This function creates a regular two-dimensional grid of cells (unless a
custom grid is specified with \code{grid}) and calculates the difference
between the number of points in each grid cell:
\itemize{
\item before and after a set point in time, if \code{boundary} is specified,
\item between two groups of points, if a column of grouping values is specified
with \code{groups},
\item before and after the mid-point of the dates/times present in the data, if
both \code{boundary} and \code{groups} are \code{NULL} (the default).
}

If both \code{boundary} and \code{groups} are not \code{NULL}, the value of
\code{boundary} will be ignored.
\subsection{Coverage of the output data}{

The grid produced by this function covers the convex hull of the input data
layer. This means the result may include zero counts for cells that are
outside the area for which data were provided, which could be misleading. To
handle this, consider cropping the output layer to the area for which data
are available. For example, if you only have crime data for a particular
district, crop the output dataset to the district boundary using
\code{\link[sf]{st_intersection}}.
}

\subsection{Automatic cell-size selection}{

If no cell size is given then the cell size will be set so that there are 50
cells on the shorter side of the grid. If the \code{data} SF object is
projected in metres or feet, the number of cells will be adjusted upwards so
that the cell size is a multiple of 100.
}
}
\examples{

# Compare counts from the first half of the period covered by the data to
# counts from the second half
\donttest{
hotspot_change(memphis_robberies)
}

# Create a grouping variable, then compare counts across values of that
# variable
\donttest{
memphis_robberies$weekend <-
  weekdays(memphis_robberies$date) \%in\% c("Saturday", "Sunday")
hotspot_change(memphis_robberies, groups = weekend)
}

}
\seealso{
\code{\link[=hotspot_dual_kde]{hotspot_dual_kde()}} for comparing the density of two layers, which
will often be more useful than comparing counts if the point locations
represent and underlying continuous distribution.
}
