% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.sfnetwork}
\title{Extract the active element of a sfnetwork as spatial tibble}
\usage{
\method{as_tibble}{sfnetwork}(x, active = NULL, spatial = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{\link{sfnetwork}}.}

\item{active}{Which network element (i.e. nodes or edges) to activate before
extracting. If \code{NULL}, it will be set to the current active element of
the given network. Defaults to \code{NULL}.}

\item{spatial}{Should the extracted tibble be a 'spatial tibble', i.e. an
object of class \code{c('sf', 'tbl_df')}, if it contains a geometry list
column. Defaults to \code{TRUE}.}

\item{...}{Arguments passed on to \code{\link[tibble]{as_tibble}}.}
}
\value{
The active element of the network as an object of class
\code{\link[tibble]{tibble}}.
}
\description{
The sfnetwork method for \code{\link[tibble]{as_tibble}} is conceptually
different. Whenever a geometry list column is present, it will by default
return what we call a 'spatial tibble'. With that we mean an object of
class \code{c('sf', 'tbl_df')} instead of an object of class
\code{'tbl_df'}. This little conceptual trick is essential for how
tidyverse functions handle \code{\link{sfnetwork}} objects, i.e. always
using the corresponding \code{\link[sf]{sf}} method if present. When using
\code{\link[tibble]{as_tibble}} on \code{\link{sfnetwork}} objects directly
as a user, you can disable this behaviour by setting \code{spatial = FALSE}.
}
\examples{
library(tibble, quietly = TRUE)

net = as_sfnetwork(roxel)

# Extract the active network element as a spatial tibble.
as_tibble(net)

# Extract any network element as a spatial tibble.
as_tibble(net, "edges")

# Extract the active network element as a regular tibble.
as_tibble(net, spatial = FALSE)

}
