% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sftime.R
\name{transform.sftime}
\alias{transform.sftime}
\title{Transform method for \code{sftime} objects}
\usage{
\method{transform}{sftime}(`_data`, ...)
}
\arguments{
\item{_data}{An object of class \code{\link[=st_sftime]{sftime}}.}

\item{...}{Further arguments of the form new_variable=expression}
}
\value{
\code{_data} (an \code{sftime} object) with modified attribute values 
(columns).
}
\description{
Can be used to create or modify attribute variables; for transforming 
geometries see \code{\link[sf]{st_transform}}, and all other functions starting with 
\code{st_}.
}
\examples{
# create an sftime object
g <- st_sfc(st_point(c(1, 2)), st_point(c(1, 3)), st_point(c(2, 3)), 
     st_point(c(2, 1)), st_point(c(3, 1)))
x <- 
   data.frame(a = 1:5, g, time = Sys.time() + 1:5, stringsAsFactors = FALSE)
x_sftime <- st_as_sftime(x)
x_sftime

# modify values in column a
transform(x_sftime, a = rev(a))

}
