% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossval.R
\name{sgdgmf.cv.step}
\alias{sgdgmf.cv.step}
\title{Single step of cross-validation for generalized matrix factorization models}
\usage{
sgdgmf.cv.step(
  train,
  test,
  X,
  Z,
  family,
  ncomp,
  maxcomp,
  fold,
  nfolds,
  weights,
  offset,
  method,
  sampling,
  penalty,
  control.init,
  control.alg,
  control.cv
)
}
\arguments{
\item{train}{train-set matrix of responses (\eqn{n \times m})}

\item{test}{test-set matrix of responses (\eqn{n \times m})}

\item{X}{matrix of row fixed effects (\eqn{n \times p})}

\item{Z}{matrix of column fixed effects (\eqn{q \times m})}

\item{family}{a \code{glm} family (see \code{\link{family}} for more details)}

\item{ncomp}{ranks of the latent matrix factorization used in cross-validation (default 1 to 10)}

\item{maxcomp}{maximum rank allowed in the cross-validation exploration}

\item{fold}{integer number identifying the current fold}

\item{nfolds}{maximum number of folds in the cross-validation}

\item{weights}{an optional matrix of weights (\eqn{n \times m})}

\item{offset}{an optional matrix of offset values (\eqn{n \times m}), that specify a known component to be included in the linear predictor.}

\item{method}{estimation method to minimize the negative penalized log-likelihood}

\item{sampling}{sub-sampling strategy to use if \code{method = "sgd"}}

\item{penalty}{list of penalty parameters (see \code{\link{set.penalty}} for more details)}

\item{control.init}{list of control parameters for the initialization (see \code{\link{set.control.init}} for more details)}

\item{control.alg}{list of control parameters for the optimization (see \code{\link{set.control.alg}} for more details)}

\item{control.cv}{list of control parameters for the cross-validation (see \code{\link{set.control.cv}} for more details)}
}
\value{
Returns a \code{data.frame}  containing the current number of latent factors
in the model (\code{ncomp}), the fold identifier (\code{fold}), the degrees of
freedom, i.e. the number of parameters, of the model (\code{df}), the AIC, BIC
and deviance (respectively, \code{aic}, \code{bic}, \code{dev})
calculated on the train and test sets.
}
\description{
Internal function running a single step of cross-validation for generalized
matrix factorization (GMF) models and calculating some goodness-of-fit measures
on the train and test sets.
}
\keyword{internal}
