% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{initSess}
\alias{initSess}
\title{Initialise TensorFlow session and sgmcmc algorithm}
\usage{
initSess(sgmcmc, verbose = TRUE)
}
\arguments{
\item{sgmcmc}{an sgmcmc object created using *Setup e.g. \code{\link{sgldSetup}}, 
\code{\link{sgldcvSetup}}}

\item{verbose}{optional. Default TRUE. Boolean specifying whether to print progress.}
}
\value{
sess a TensorFlow session, see the 
 \href{https://tensorflow.rstudio.com/}{TensorFlow for R website} for more details.
}
\description{
Initialise the TensorFlow session and the sgmcmc algorithm. For algorithms with control variates
 this will find the MAP estimates of the log posterior and calculate the full log posterior
 gradient at this point. For algorithms without control variates this will simply initialise a
 TensorFlow session.
}
\examples{
\dontrun{
# Simulate from a Normal Distribution, unknown location and known scale with uninformative prior
# Run sgmcmc step by step and calculate estimate of location on the fly to reduce storage
dataset = list("x" = rnorm(1000))
params = list("theta" = 0)
logLik = function(params, dataset) {
    distn = tf$contrib$distributions$Normal(params$theta, 1)
    return(tf$reduce_sum(distn$log_prob(dataset$x)))
}
stepsize = list("theta" = 1e-4)
sgld = sgldSetup(logLik, dataset, params, stepsize)
nIters = 10^4L
# Initialize location estimate
locEstimate = 0
# Initialise TensorFlow session
sess = initSess(sgld)
for ( i in 1:nIters ) {
    sgmcmcStep(sgld, sess)
    locEstimate = locEstimate + 1 / nIters * getParams(sgld, sess)$theta
}
# For more examples see vignettes
}
}
