% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toSeg.R
\name{toSeg}
\alias{toSeg}
\title{Convert polygons or lines to segments}
\usage{
toSeg(x)
}
\arguments{
\item{x}{A \code{SpatialLines*} or a \code{SpatialPolygons*} object.}
}
\value{
A \code{SpatialLines} object where each segment is represented by a separate feature.
}
\description{
Split lines or polygons to separate segments.
}
\examples{
data(build)
seg = toSeg(build[1, ])
plot(seg, col = sample(rainbow(length(seg))))
raster::text(rgeos::gCentroid(seg, byid = TRUE), 1:length(seg))

# Other data structures
toSeg(geometry(build)) # SpatialPolygons
toSeg(sidewalk) # SpatialLinesDataFrame
toSeg(geometry(sidewalk)) # SpatialLinesDataFrame

}
\references{
This function uses a modified version of code from the following 'r-sig-geo' post by Roger Bivand:
\url{https://stat.ethz.ch/pipermail/r-sig-geo/2013-April/017998.html}
}
