package org.ddahl.shallot
package parameter

import partition._

trait SamplingModel[A] {

  type tipe = A

  def sample: A

  def sample(subset: Subset[A]): A

  def copy(x: A): A = x

  def logDensity(i: Int, subset: Subset[A]): Double

}

object NullSamplingModel extends SamplingModel[Null] {

  def sample = null

  def sample(subset: Subset[Null]) = null

  def logDensity(i: Int, subset: Subset[Null]) = 0.0

}

