% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_marks.R
\name{reconstruct_marks}
\alias{reconstruct_marks}
\title{reconstruct_marks}
\usage{
reconstruct_marks(pattern, marked_pattern, n_random = 19,
  e_threshold = 0.01, max_runs = 10000, return_input = TRUE,
  simplify = FALSE, verbose = TRUE, plot = FALSE)
}
\arguments{
\item{pattern}{ppp.}

\item{marked_pattern}{ppp (marked; see details).}

\item{n_random}{Number of randomizations.}

\item{e_threshold}{Minimum energy to stop reconstruction.}

\item{max_runs}{Maximum number of iterations of e_threshold is not reached.}

\item{return_input}{The original input data is returned as last list entry}

\item{simplify}{If n_random = 1 and return_input = FALSE only pattern will be returned.}

\item{verbose}{Print progress report.}

\item{plot}{Plot kmmr function during optimization.}
}
\value{
list
}
\description{
Pattern reconstruction of marks
}
\details{
The function randomizes the numeric marks of a point pattern using pattern reconstruction
as described in Tscheschel & Stoyan (2006) and Wiegand & Moloney (2014). Therefore,
an unmarked as well as a marked pattern must be provided. The unmarked pattern must have
the spatial characteristics but the same observation window and number of points
as the marked one (see `reconstruct_pattern` or `fit_point_process`). Marks must be
numeric because the mark-correlation function is used as summary function. Two
randomly chosen marks are switch each iterations and changes only kept if the
deviation between the observed and the reconstructed pattern decreases.
}
\examples{
\dontrun{
pattern_recon <- reconstruct_pattern(species_a, n_random = 1, max_runs = 1000)[[1]]
marks_sub <- spatstat::subset.ppp(species_a, select = dbh)
marks_recon <- reconstruct_marks(pattern_recon, marks_sub, n_random = 19, max_runs = 1000)
}

}
\references{
Tscheschel, A., & Stoyan, D. (2006). Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis, 51(2), 859–871.

Wiegand, T., & Moloney, K. A. (2014). Handbook of spatial point-pattern analysis
in ecology. Boca Raton: Chapman and Hall/CRC Press.
}
\seealso{
\code{\link{reconstruct_pattern}} \cr
\code{\link{fit_point_process}} \cr
}
