% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_block.R
\name{BlockLambdaGrid}
\alias{BlockLambdaGrid}
\title{Multi-block grid}
\usage{
BlockLambdaGrid(Lambda, lambda_other_blocks = NULL)
}
\arguments{
\item{Lambda}{vector or matrix of penalty parameters.}

\item{lambda_other_blocks}{optional vector of penalty parameters to use for
other blocks in the iterative multi-block procedure.}
}
\value{
A list with: \item{Lambda}{a matrix of (block-specific) penalty
  parameters. In multi-block stability selection, rows correspond to sets of
  penalty parameters and columns correspond to different blocks.}
  \item{Sequential_template}{logical matrix encoding the type of procedure
  for data with multiple blocks in stability selection graphical modelling.
  For multi-block estimation, each block is calibrated separately while
  others blocks are weakly penalised (\code{TRUE} only for the block
  currently being calibrated and \code{FALSE} for other blocks). Other
  approaches with joint calibration of the blocks are allowed (all entries
  are set to \code{TRUE}).}
}
\description{
Generates a matrix of parameters controlling the sparsity of the underlying
selection algorithm for multi-block calibration.
}
\examples{
# Multi-block grid
Lambda <- matrix(c(
  0.8, 0.6, 0.3,
  0.5, 0.4, 0.2,
  0.7, 0.5, 0.1
),
ncol = 3, byrow = TRUE
)
mygrid <- BlockLambdaGrid(Lambda, lambda_other_blocks = 0.1)

# Multi-parameter grid (not recommended)
Lambda <- matrix(c(
  0.8, 0.6, 0.3,
  0.5, 0.4, 0.2,
  0.7, 0.5, 0.1
),
ncol = 3, byrow = TRUE
)
mygrid <- BlockLambdaGrid(Lambda, lambda_other_blocks = NULL)
}
\seealso{
\code{\link{GraphicalModel}}

Other multi-block functions: 
\code{\link{BlockMatrix}()},
\code{\link{BlockStructure}()}
}
\concept{multi-block functions}
