% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{SimulateAdjacency}
\alias{SimulateAdjacency}
\title{Simulation of an undirected graph with block structure}
\usage{
SimulateAdjacency(
  pk = 10,
  implementation = HugeAdjacency,
  topology = "random",
  nu_within = 0.1,
  nu_between = 0,
  ...
)
}
\arguments{
\item{pk}{vector of the number of variables per group in the simulated data.
The number of nodes in the simulated graph is \code{sum(pk)}. With multiple
groups, the simulated (partial) correlation matrix has a block structure,
where blocks arise from the integration of the \code{length(pk)} groups.
This argument is only used if \code{sum(pk)} is equal to the number of
rows/columns in \code{theta} is not provided.}

\item{implementation}{function for simulation of the graph. By default,
algorithms implemented in \code{\link[huge]{huge.generator}} are used.
Alternatively, a user-defined function can be used. It must take \code{pk},
\code{topology} and \code{nu} as arguments and return a
\code{(sum(pk)*(sum(pk)))} binary and symmetric matrix for which diagonal
entries are all equal to zero. This function is only applied if
\code{theta} is not provided.}

\item{topology}{topology of the simulated graph. If using
\code{implementation=HugeAdjacency}, possible values are listed for the
argument \code{graph} of \code{\link[huge]{huge.generator}}. These are:
"random", "hub", "cluster", "band" and "scale-free".}

\item{nu_within}{expected density (number of edges over the number of node
pairs) of within-group blocks in the graph. If \code{length(pk)=1}, this is
the expected density of the graph. If \code{implementation=HugeAdjacency},
this argument is only used for \code{topology="random"} or
\code{topology="cluster"} (see argument \code{prob} in
\code{\link[huge]{huge.generator}}).}

\item{nu_between}{expected density (number of edges over the number of node
pairs) of between-group blocks in the graph. Similar to \code{nu_within}.
By default, the same density is used for within and between blocks
(\code{nu_within}=\code{nu_between}). Only used if \code{length(pk)>1}.}

\item{...}{additional arguments passed to the graph simulation function
provided in \code{implementation}.}
}
\value{
A symmetric adjacency matrix encoding an unweighted, undirected graph
  with no self-loops, and with different densities in diagonal compared to off-diagonal
blocks.
}
\description{
Simulates the adjacency matrix of an unweighted, undirected graph with no
self-loops, and with different densities in diagonal compared to off-diagonal
blocks.
}
\examples{
# Simulation of a scale-free graph with 20 nodes
adjacency <- SimulateAdjacency(pk = 20, topology = "scale-free")
plot(Graph(adjacency))

# Simulation of a random graph with block structure
adjacency <- SimulateAdjacency(
  pk = rep(10, 3),
  nu_within = 0.7, nu_between = 0.03
)
plot(Graph(adjacency))

# User-defined function for graph simulation
CentralNode <- function(pk, hub = 1) {
  theta <- matrix(0, nrow = sum(pk), ncol = sum(pk))
  theta[hub, ] <- 1
  theta[, hub] <- 1
  diag(theta) <- 0
  return(theta)
}
simul <- SimulateAdjacency(pk = 10, implementation = CentralNode)
plot(Graph(simul)) # star
simul <- SimulateAdjacency(pk = 10, implementation = CentralNode, hub = 2)
plot(Graph(simul)) # variable 2 is the central node
}
\seealso{
Other simulation functions: 
\code{\link{SimulateComponents}()},
\code{\link{SimulateGraphical}()},
\code{\link{SimulateRegression}()}
}
\concept{simulation functions}
