% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dailyWB_SSURGO.R
\name{dailyWB_SSURGO}
\alias{dailyWB_SSURGO}
\title{Perform daily water balance modeling using SSURGO and DAYMET}
\usage{
dailyWB_SSURGO(
  x,
  cokeys = NULL,
  start = 1988,
  end = 2018,
  modelDepth = 100,
  bufferRadiusMeters = 1,
  ...
)
}
\arguments{
\item{x}{\code{SpatialPoints} object representing a single point}

\item{cokeys}{vector of component keys to use}

\item{start}{starting year (limited to DAYMET holdings)}

\item{end}{ending year (limited to DAYMET holdings)}

\item{modelDepth}{soil depth used for water balance, see details}

\item{bufferRadiusMeters}{spatial buffer (meters) applied to \code{x} for the lookup of SSURGO data}

\item{...}{additional arguments to \code{\link{simpleWB}}}
}
\value{
\code{data.frame} of daily water balance results
}
\description{
Perform daily water balance modeling using SSURGO and DAYMET
}
\references{
Farmer, D., M. Sivapalan, Farmer, D. (2003). Climate, soil and vegetation controls upon the variability of water balance in temperate and semiarid landscapes: downward approach to water balance analysis. Water Resources Research 39(2), p 1035.
}
\author{
D.E. Beaudette
}
