% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vizMountainPosition.R
\name{vizMountainPosition}
\alias{vizMountainPosition}
\title{Visual Summary of Mountain Slope Positions}
\usage{
vizMountainPosition(
  x,
  s = NULL,
  annotations = TRUE,
  annotation.cex = 0.75,
  cols = c("#D53E4F", "#FC8D59", "#FEE08B", "#E6F598", "#99D594", "#3288BD")
)
}
\arguments{
\item{x}{\code{data.frame} as created by \code{soilDB::fetchOSD(..., extended=TRUE)}, see details}

\item{s}{an optional soil series name, highlighted in the figure}

\item{annotations}{logical, add number of record and normalized Shannon entropy values}

\item{annotation.cex}{annotation label scaling factor}

\item{cols}{vector of colors}
}
\value{
A \code{list} with the following elements:
\itemize{
\item \code{fig}: lattice object (the figure)
\item \code{order}: 1D ordering from \code{cluster::diana}
\item \code{clust}: clustering object returned by \code{cluster::diana}
}
}
\description{
A unique display of mountain slope position probability.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/soilDB/soil-series-query-functions.html}{Soil Series Query Functions} tutorial for more information.
}
\author{
D.E. Beaudette
}
