% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydOrder.R
\name{hydOrder}
\alias{hydOrder}
\title{Hydrologic Ordering of a Geomorphic Proportion Matrix}
\usage{
hydOrder(x, g, clust = TRUE, j.amount = 0)
}
\arguments{
\item{x}{x \code{data.frame}, geomorphic proportion matrix, as created by \code{soilDB::fetchOSD(..., extended=TRUE)}}

\item{g}{character, name of geomorphic summary table, one of: \code{c('geomcomp', 'hillpos', 'flats', 'terrace', 'mtnpos', 'shape')}}

\item{clust}{logical, perform clustering of geomorphic proportion matrix}

\item{j.amount}{amount of noise applied to rows having a duplicate proportion vector, passed to \code{jitter()}}
}
\value{
when \code{clust = FALSE} a vector of series names, in hydrologic ordering, otherwise a \code{list} with the following elements:
\itemize{
\item \code{clust}: rotated \code{hclust} object
\item \code{hyd.order}: vector of series names, in hydrologic ordering
\item \code{clust.hyd.order}: vector of series names, after clustering + rotation, approximate hydrologic ordering
\item \code{match.rate}: fraction of series matching target hydrologic ordering, after clustering + rotation
\item \code{obj}: objective function value (sum of squared rank differences), used by \code{\link[=iterateHydOrder]{iterateHydOrder()}}
}
}
\description{
Hydrologic Ordering of a Geomorphic Proportion Matrix
}
\examples{

# example data, similar to results from soilDB::fetchOSD(..., extended = TRUE)
data("OSDexamples")

# no clustering of the geomorphic proportion matrix
h <- hydOrder(OSDexamples$hillpos, g = 'hillpos', clust = FALSE)

# compare with original order

data.frame(
original = OSDexamples$hillpos$series,
ordered = h
)

# cluster results
h <- hydOrder(OSDexamples$hillpos, g = 'hillpos', clust = TRUE)
str(h)
}
\author{
D.E. Beaudette
}
