% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_test.R
\name{run_test}
\alias{run_test}
\title{Function to test the shattering coefficient estimation}
\usage{
run_test(
  mean = c(-1, 1),
  n = 100,
  length = 5,
  quantile.percentage = 1,
  plot = TRUE,
  epsilon = 1e-07
)
}
\arguments{
\item{mean}{2-d numeric vector with Gaussian averages}

\item{n}{number of instances to be synthetically generated}

\item{length}{number of instances per class}

\item{quantile.percentage}{real number to define the quantile of distances to be considered (e.g. 0.1 means 10\%)}

\item{plot}{should we plot?}

\item{epsilon}{a real threshold to be removed from distances in order to measure the open balls in the underlying topology}
}
\value{
A list including the number of hyperplanes and the shattering coefficient function
}
\description{
This is a simple test function
}
\examples{
# A first basic example:
run_test(mean=c(-1,1), n=100, length=5, quantile.percentage=0.1, plot=TRUE, epsilon=1e-7)

# Changing the averages of the 2D Gaussian functions:
run_test(mean=c(-5,5), n=100, length=5, quantile.percentage=0.1, plot=TRUE, epsilon=1e-7)

# Considering all points of the space (see parameter quantile.percentage):
run_test(mean=c(-5,5), n=50, length=5, quantile.percentage=1, plot=TRUE, epsilon=1e-7)

# Considering 5\% of the closest points of the space (see parameter quantile.percentage):
run_test(mean=c(-5,5), n=100, length=5, quantile.percentage=0.05, plot=TRUE, epsilon=1e-7)

# Changing the number of random examples to 300
# (the positive class with 150 and the negative with the remaining 150 examples)
run_test(mean=c(-5,5), n=150, length=5, quantile.percentage=0.05, plot=TRUE, epsilon=1e-7)

# Parameter epsilon defines some value to be removed from the closest point of the positive
# class to its nearest neighbor of the negative class (and vice-versa):
run_test(mean=c(-5,5), n=50, length=5, quantile.percentage=0.05, plot=TRUE, epsilon=1e-7)

}
\keyword{estimation}
\keyword{run}
\keyword{shattering}
\keyword{test}
