% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_low_high_units_manual.R
\name{select_low_high_units_manual}
\alias{select_low_high_units_manual}
\title{Select Low-High Units}
\usage{
select_low_high_units_manual(
  data,
  select_units_by = "row_number",
  lowest_units,
  highest_units,
  part_id_col
)
}
\arguments{
\item{data}{input dataset (required)}

\item{select_units_by}{Set to select units either based on row number or part ID. Options are "row_number" and "part_id". By default, it is set to "row_number". (required)}

\item{lowest_units}{A numerical or character vector of the lowest units selected. Examples: c(1, 6, 8, 12), c("part5", "part45", "part9", "part23"). (required)}

\item{highest_units}{A numerical or character vector of the lowest units selected. Examples: c(1, 6, 8, 12), c("part5", "part45", "part9", "part23"). (required)}

\item{part_id_col}{Set column for part id. Only to be used when select_units_by is set to "part_id".}
}
\value{
A tibble object filtered down to the low-high units selected
}
\description{
Select low-high units manually in a tibble and assign them into groups
}
