% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_cypress.R
\name{benchmark_cypress}
\alias{benchmark_cypress}
\title{Run the performance test based on multiple commits using Cypress}
\usage{
benchmark_cypress(
  commit_list,
  cypress_dir,
  tests_pattern,
  app_dir,
  port,
  use_renv,
  renv_prompt,
  n_rep,
  debug
)
}
\arguments{
\item{commit_list}{A list of commit hash codes, branches' names or anything
else you can use with git checkout \link{...}}

\item{cypress_dir}{The directory with tests recorded by Cypress.
It can also be a vector of the same size of commit_list}

\item{tests_pattern}{Cypress/shinytest2 files pattern. E.g. 'shinytest2'
It can also be a vector of the same size of commit_list. If it is NULL,
all the content in cypress_dir/shinytest2_dir will be used}

\item{app_dir}{The path to the application root}

\item{port}{Port to run the app}

\item{use_renv}{In case it is set as TRUE, package will try to apply
renv::restore() in all branches. Otherwise, the current loaded list of
packages will be used in all branches.}

\item{renv_prompt}{Prompt the user before taking any action?}

\item{n_rep}{Number of replications desired}

\item{debug}{Logical. TRUE to display all the system messages on runtime}
}
\value{
Return a \code{list} with the collected performance times
}
\description{
Run the performance test based on multiple commits using Cypress
}
