% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{render_session_info}
\alias{render_session_info}
\title{Server render function for rendering informations about user session (app URL, username and pixel ratio)}
\usage{
render_session_info()
}
\value{
Shiny render function to be saved as an element of output.
}
\description{
Server render function for rendering informations about user session (app URL, username and pixel ratio)
}
\details{
Use it with info_value UI function. If you want to use it with toggle_info(),
 you have to add outputOptions(output, [session info id], suspendWhenHidden = FALSE) to force
 rendering when the value is hidden.
}
\examples{
if(interactive()){
library(shiny)
library(shiny.info)

ui <- fluidPage(
   info_value("session_info")
)

server <- function(input, output, session) {
  outputsession_info <- render_session_info()
  # next line is required to work with toggle_info()
  outputOptions(output, "session_info", suspendWhenHidden = FALSE)
}
}
}
