% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{tableOutput}
\alias{dataTableOutput}
\alias{tableOutput}
\title{Create a table output element}
\usage{
tableOutput(outputId)

dataTableOutput(outputId)
}
\arguments{
\item{outputId}{output variable to read the table from}
}
\value{
A table output element that can be included in a panel
}
\description{
Render a \code{\link{renderTable}} or \code{\link{renderDataTable}} within an
application page. \code{renderTable} uses a standard HTML table, while
\code{renderDataTable} uses the DataTables Javascript library to create an
interactive table with more features.
}
\examples{
\donttest{
# table example
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(12,
        tableOutput('table')
      )
    )
  ),
  server = function(input, output) {
    output$table <- renderTable(iris)
  }
)


# DataTables example
shinyApp(
  ui = fluidPage(
    fluidRow(
      column(12,
        dataTableOutput('table')
      )
    )
  ),
  server = function(input, output) {
    output$table <- renderDataTable(iris)
  }
)
}
}
\seealso{
\code{\link{renderTable}}, \code{\link{renderDataTable}}.
}

