% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{shiny-options}
\alias{shiny-options}
\title{Global options for Shiny}
\description{
There are a number of global options that affect Shiny's behavior. These can
be set with (for example) \code{options(shiny.trace=TRUE)}.
}
\details{
\describe{
  \item{shiny.launch.browser}{A boolean which controls the default behavior
    when an app is run. See \code{\link{runApp}} for more information.}
  \item{shiny.port}{A port number that Shiny will listen on. See
    \code{\link{runApp}} for more information.}
  \item{shiny.trace}{Print messages sent between the R server and the web
    browser client to the R console. This is useful for debugging. Possible
    values are \code{"send"} (only print messages sent to the client),
    \code{"recv"} (only print messages received by the server), \code{TRUE}
    (print all messages), or \code{FALSE} (default; don't print any of these
    messages).}
  \item{shiny.autoreload}{If \code{TRUE} when a Shiny app is launched, the
    app directory will be continually monitored for changes to files that
    have the extensions: r, htm, html, js, css, png, jpg, jpeg, gif. If any
    changes are detected, all connected Shiny sessions are reloaded. This
    allows for fast feedback loops when tweaking Shiny UI.

Since monitoring for changes is expensive (we simply poll for last
    modified times), this feature is intended only for development.

You can customize the file patterns Shiny will monitor by setting the
    shiny.autoreload.pattern option. For example, to monitor only ui.R:
    \code{options(shiny.autoreload.pattern = glob2rx("ui.R"))}

The default polling interval is 500 milliseconds. You can change this
    by setting e.g. \code{options(shiny.autoreload.interval = 2000)} (every
    two seconds).}
  \item{shiny.reactlog}{If \code{TRUE}, enable logging of reactive events,
    which can be viewed later with the \code{\link{showReactLog}} function.
    This incurs a substantial performance penalty and should not be used in
    production.}
  \item{shiny.usecairo}{This is used to disable graphical rendering by the
    Cairo package, if it is installed. See \code{\link{plotPNG}} for more
    information.}
  \item{shiny.maxRequestSize}{This is a number which specifies the maximum
    web request size, which serves as a size limit for file uploads. If
    unset, the maximum request size defaults to 5MB.}
  \item{shiny.suppressMissingContextError}{Normally, invoking a reactive
    outside of a reactive context (or \code{\link{isolate}()}) results in
    an error. If this is \code{TRUE}, don't error in these cases. This
    should only be used for debugging or demonstrations of reactivity at the
    console.}
  \item{shiny.host}{The IP address that Shiny should listen on. See
    \code{\link{runApp}} for more information.}
  \item{shiny.json.digits}{The number of digits to use when converting
    numbers to JSON format to send to the client web browser.}
  \item{shiny.minified}{If this is \code{TRUE} or unset (the default), then
    Shiny will use minified JavaScript (\code{shiny.min.js}). If
    \code{FALSE}, then Shiny will use the un-minified JavaScript
    (\code{shiny.js}); this can be useful during development.}
  \item{shiny.error}{This can be a function which is called when an error
    occurs. For example, \code{options(shiny.error=recover)} will result a
    the debugger prompt when an error occurs.}
  \item{shiny.table.class}{CSS class names to use for tables.}
  \item{shiny.deprecation.messages}{This controls whether messages for
    deprecated functions in Shiny will be printed. See
    \code{\link{shinyDeprecated}} for more information.}
  \item{shiny.fullstacktrace}{Controls whether "pretty" or full stack traces
    are dumped to the console when errors occur during Shiny app execution.
    The default is \code{FALSE} (pretty stack traces).}
  \item{shiny.stacktraceoffset}{If \code{TRUE}, then Shiny's printed stack
    traces will display srcrefs one line above their usual location. This is
    an arguably more intuitive arrangement for casual R users, as the name
    of a function appears next to the srcref where it is defined, rather than
    where it is currently being called from.}
  \item{shiny.sanitize.errors}{If \code{TRUE}, then normal errors (i.e.
    errors not wrapped in \code{safeError}) won't show up in the app; a simple
    generic error message is printed instead (the error and strack trace printed
    to the console remain unchanged). The default is \code{FALSE} (unsanitized
    errors).If you want to sanitize errors in general, but you DO want a
    particular error \code{e} to get displayed to the user, then set this option
    to \code{TRUE} and use \code{stop(safeError(e))} for errors you want the
    user to see.}
  \item{shiny.testmode}{If \code{TRUE}, then enable features for testing Shiny
    applications. If \code{FALSE} (the default), do not enable those features.
  }
}
}
