% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_value.R
\name{log_value}
\alias{log_value}
\title{Logging value}
\usage{
log_value(..., type = "VALUE", status = "FIRED", params = NULL)
}
\arguments{
\item{...}{A function call that is evaluated, the returned value is
coerced into character string,
and pasted into log entry body.
Deparsed function call is used as the event name in log entry header.}

\item{type}{A character string. A type of the event.
Default is \code{"VALUE"}.}

\item{status}{A character string. A status of the event.
Default is \code{"FIRED"}.}

\item{params}{A list of additional named event-specific parameters.
Default is \code{NULL}.}
}
\description{
\code{log_value} logs value of an evaluated function into log entry body
and uses deparsed function call as the event name.
}
\examples{
if (interactive()) {
  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
      log_value(NROW(mtcars))
    }
  )

}
}
\seealso{
Other logging events functions: \code{\link{log_event}},
  \code{\link{log_message}}, \code{\link{log_output}},
  \code{\link{log_started}}, \code{\link{log_test}}
}
\concept{logging events functions}
