% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purge_eventlog.R
\name{purge_eventlog}
\alias{purge_eventlog}
\title{Purging eventlog}
\usage{
purge_eventlog(file = "events.log", min_build = NULL)
}
\arguments{
\item{file}{A character string. Path to a file log.}

\item{min_build}{An integer. Minimum build version of the app
that should be kept in the eventlog after purging.}
}
\description{
\code{purge_eventlog} removes obsolete event records based
on selected criteria.
Please be careful. If you do not back up your eventlog, purging
operation can be irreversible.
}
\examples{
\donttest{

 demo_filelog <- system.file("shiny", "demoapp/events.log",
                             package = "shinyEventLogger")

 temp_file <- tempfile()
 file_conn <- base::file(temp_file)
 writeLines(readLines(con = demo_filelog), file_conn)
 close(file_conn)

 purge_eventlog(file = temp_file, min_build = 23)
}
}
