% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-update-inputs.R
\name{updateF7Slider}
\alias{updateF7Slider}
\title{Change the value of a slider input on the client}
\usage{
updateF7Slider(
  session,
  inputId,
  min = NULL,
  max = NULL,
  value = NULL,
  scale = FALSE
)
}
\arguments{
\item{session}{The session object passed to function given to the server.}

\item{inputId}{The id of the input object.}

\item{min}{Slider minimum range.}

\item{max}{Slider maximum range}

\item{value}{Slider value or a vector containing 2 values (for a range).}

\item{scale}{Slider scale.}
}
\description{
Change the value of a slider input on the client
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Slider"),
      f7Card(
        f7Button(inputId = "update", label = "Update slider"),
        f7Slider(
          inputId = "obs",
          label = "Range values",
          max = 500,
          min = 0,
          value = c(50, 100),
          scale = TRUE,
          vertical = FALSE
        ),
        verbatimTextOutput("test")
      )
    )
  ),
  server = function(input, output, session) {

    output$test <- renderPrint({input$obs})

    observeEvent(input$update, {
      updateF7Slider(
        session,
        inputId = "obs",
        value = c(20, 40),
        min = 10,
        max = 50,
        scale = FALSE
      )
    })
  }
 )
}
}
