% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Popover.R
\name{f7Popover}
\alias{f7Popover}
\alias{f7PopoverTarget}
\alias{addF7Popover}
\alias{toggleF7Popover}
\title{Framework7 popover}
\usage{
f7Popover(targetId, content, session = shiny::getDefaultReactiveDomain())

f7PopoverTarget(tag, targetId)

addF7Popover(
  id = NULL,
  selector = NULL,
  options,
  session = shiny::getDefaultReactiveDomain()
)

toggleF7Popover(
  id = NULL,
  selector = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{targetId}{Popover id. Must correspond to the \link{f7Popover} targetId.}

\item{content}{Popover content.}

\item{session}{Shiny session object.}

\item{tag}{Tag that will be targeted. Must be a f7Input element.}

\item{id}{Popover target id.}

\item{selector}{jQuery selector. Allow more customization for the target (nested tags).}

\item{options}{List of options to pass to the popover. See \url{https://framework7.io/docs/popover.html#popover-parameters}.}
}
\description{
\link{f7Popover} is deprecated. It has to be used in an oberve
or observeEvent context. Only works for input elements!

\link{f7PopoverTarget} is deprecated. This must be used in combination of \link{f7Popover}.
Only works for input elements!

\link{addF7Popover} adds a popover to the given target and show it if enabled
by \link{toggleF7Popover}.

\link{toggleF7Popover} toggles the visibility of popover. See example for use case.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
   ui = f7Page(
     title = "f7Popover",
     f7SingleLayout(
       navbar = f7Navbar(title = "f7Popover"),
       f7PopoverTarget(
         f7Button(
           inputId = "goButton",
           "Go!"
         ),
         targetId = "test"
       ),
       br(),
       br(),
       f7PopoverTarget(
         f7Slider(
           inputId = "slider",
           label = "Value",
           value = 10,
           min = 0,
           max = 20
         ),
         targetId = "test2"
       )
     )
   ),
   server = function(input, output, session) {
     observe({
       f7Popover(
         targetId = "test",
         content = "This is a f7Button"
       )
     })

     observe({
       f7Popover(
         targetId = "test2",
         content = "This is a f7Slider"
       )
     })
   }
 )
}
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 lorem_ipsum <- "Lorem ipsum dolor sit amet,
           consectetur adipiscing elit. Quisque ac diam ac quam euismod
           porta vel a nunc. Quisque sodales scelerisque est, at porta
           justo cursus ac."

 popovers <- data.frame(
   id = paste0("target_", 1:10),
   content = paste("Popover content", 1:10, lorem_ipsum),
   stringsAsFactors = FALSE
 )


 shinyApp(
   ui = f7Page(
     options = list(theme = "ios"),
     title = "f7Popover",
     f7SingleLayout(
       navbar = f7Navbar(
         title = "f7Popover",
         subNavbar = f7SubNavbar(
           f7Toggle(
             inputId = "toggle",
             "Enable popover",
             color = "green",
             checked = TRUE
           )
         )
       ),
       f7Segment(
         lapply(seq_len(nrow(popovers)), function(i) {
           f7Button(
             inputId = sprintf("target_\%s", i),
             sprintf("Target \%s", i)
           )
         })
       )
     )
   ),
   server = function(input, output, session) {
     # Enable/disable (don't run first)
     observeEvent(input$toggle, {
       lapply(seq_len(nrow(popovers)), function(i) toggleF7Popover(id = popovers[i, "id"]) )
     }, ignoreInit = TRUE)

     # show
     lapply(seq_len(nrow(popovers)), function(i) {
       observeEvent(input[[popovers[i, "id"]]], {
         addF7Popover(
           id = popovers[i, "id"],
           options = list(
             content = popovers[i, "content"]
           )
         )
       })
     })
   }
 )
}
}
