% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Swiper.R
\name{f7Swiper}
\alias{f7Swiper}
\title{Framework7 swiper}
\usage{
f7Swiper(
  ...,
  id,
  options = list(speed = 400, spaceBetween = 50, slidesPerView = "auto", centeredSlides
    = TRUE, pagination = TRUE)
)
}
\arguments{
\item{...}{Slot for \link{f7Slide}.}

\item{id}{Swiper unique id.}

\item{options}{Other options. Expect a list.}
}
\description{
\link{f7Swiper} creates a Framework7 swiper container (like carousel).
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 timeline <- f7Timeline(
  sides = TRUE,
  f7TimelineItem(
   "Another text",
   date = "01 Dec",
   card = FALSE,
   time = "12:30",
   title = "Title",
   subtitle = "Subtitle",
   side = "left"
  ),
  f7TimelineItem(
   "Another text",
   date = "02 Dec",
   card = TRUE,
   time = "13:00",
   title = "Title",
   subtitle = "Subtitle"
  ),
  f7TimelineItem(
   "Another text",
   date = "03 Dec",
   card = FALSE,
   time = "14:45",
   title = "Title",
   subtitle = "Subtitle"
  )
 )

 shiny::shinyApp(
   ui = f7Page(
    title = "Swiper",
    f7SingleLayout(
     navbar = f7Navbar(title = "f7Swiper"),
     f7Swiper(
     id = "my-swiper",
     f7Slide(
      timeline
     ),
     f7Slide(
      f7Toggle(
       inputId = "toggle",
       label = "My toggle",
       color = "pink",
       checked = TRUE
      ),
      verbatimTextOutput("test")
     )
    )
    )
   ),
   server = function(input, output) {
    output$test <- renderPrint(input$toggle)
   }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
