% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Slider}
\alias{f7Slider}
\alias{updateF7Slider}
\title{Framework7 range slider}
\usage{
f7Slider(
  inputId,
  label,
  min,
  max,
  value,
  step = 1,
  scale = FALSE,
  scaleSteps = 5,
  scaleSubSteps = 0,
  vertical = FALSE,
  verticalReversed = FALSE,
  labels = NULL,
  color = NULL,
  noSwipping = TRUE,
  showLabel = TRUE,
  ...,
  style = list(inset = FALSE, outline = FALSE, strong = FALSE)
)

updateF7Slider(
  inputId,
  min = NULL,
  max = NULL,
  value = NULL,
  scale = FALSE,
  scaleSteps = NULL,
  scaleSubSteps = NULL,
  step = NULL,
  color = NULL,
  ...,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{Slider input id.}

\item{label}{Slider label.}

\item{min}{Slider minimum range.}

\item{max}{Slider maximum range.}

\item{value}{Slider value or a vector containing 2 values (for a range).}

\item{step}{Slider increase step size.}

\item{scale}{Slider scale.}

\item{scaleSteps}{Number of scale steps.}

\item{scaleSubSteps}{Number of scale sub steps (each step will be divided by this value).}

\item{vertical}{Whether to apply a vertical display. FALSE by default.}

\item{verticalReversed}{Makes vertical range slider reversed (vertical must be also enabled).
FALSE by default.}

\item{labels}{Enables additional label around range slider knob. List of 2 \link{f7Icon}
expected.}

\item{color}{See \link{getF7Colors} for valid colors.}

\item{noSwipping}{Prevent swiping when slider is manipulated in an \link{f7TabLayout}.}

\item{showLabel}{Allow bubble containing the slider value. Default
to TRUE.}

\item{...}{Other options to pass to the widget. See
\url{https://framework7.io/docs/range-slider#range-slider-parameters}.}

\item{style}{Allows to style the input. inset, outline and strong are available.}

\item{session}{The Shiny session object.}
}
\description{
\code{f7Slider} creates a f7 slider input.

\code{updateF7Slider} changes the value of a slider input on the client.
}
\note{
labels option only works when vertical is FALSE!

Important: you cannot transform a range slider into a simple slider and inversely.
}
\examples{
library(shiny)
library(shinyMobile)

app <- shinyApp(
  ui = f7Page(
    title = "My app",
    f7SingleLayout(
      navbar = f7Navbar(title = "updateF7Slider"),
      f7Block(
        f7BlockTitle("Simple slider with custom style", size = "large"),
        f7Button(inputId = "update_slider", label = "Update slider"),
        f7Slider(
          inputId = "slider",
          label = "Number of observations",
          max = 1000,
          min = 0,
          value = 100,
          scaleSteps = 5,
          scaleSubSteps = 3,
          scale = TRUE,
          color = "orange",
          labels = tagList(
            f7Icon("circle"),
            f7Icon("circle_fill")
          ),
          style = list(inset = TRUE, strong = TRUE, outline = TRUE)
        ),
        textOutput("slider_res")
      ),
      f7Block(
        f7BlockTitle("Range slider", size = "large"),
        f7Button(inputId = "update_range", label = "Update slider"),
        f7Slider(
          inputId = "range",
          label = "Range values",
          max = 500,
          min = 0,
          step = 0.01,
          color = "deeppurple",
          value = c(50, 100)
        ),
        textOutput("range_res")
      )
    )
  ),
  server = function(input, output, session) {
    output$slider_res <- renderText({
      input$slider
    })

    observeEvent(input$update_slider, {
      updateF7Slider(
        inputId = "slider",
        value = 0.05,
        min = 0,
        max = 0.01,
        scale = FALSE,
        step = 0.001,
        color = "pink"
      )
    })

    output$range_res <- renderText({
      input$range
    })

    observeEvent(input$update_range, {
      updateF7Slider(
        inputId = "range",
        value = c(1, 5),
        min = 0,
        scale = TRUE,
        step = 0.01,
        max = 10,
        color = "teal"
      )
    })
  }
)

if (interactive() || identical(Sys.getenv("TESTTHAT"), "true")) app
}
