% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomeradio.R
\name{awesomeRadio}
\alias{awesomeRadio}
\title{Awesome Radio Buttons Input Control}
\usage{
awesomeRadio(
  inputId,
  label,
  choices,
  selected = NULL,
  inline = FALSE,
  status = "primary",
  checkbox = FALSE,
  width = NULL
)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{choices}{List of values to select from (if elements of the list are named then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value (if not specified then defaults to the first value).}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally).}

\item{status}{Color of the buttons, a valid Bootstrap status : default, primary, info, success, warning, danger.}

\item{checkbox}{Logical, render radio like checkboxes (with a square shape).}

\item{width}{The width of the input, e.g. \verb{400px}, or \verb{100\%}.}
}
\value{
A set of radio buttons that can be added to a UI definition.
}
\description{
Create a set of prettier radio buttons used to select an item from a list.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  br(),
  awesomeRadio(
    inputId = "id1", label = "Make a choice:",
    choices = c("graphics", "ggplot2")
  ),
  verbatimTextOutput(outputId = "res1"),
  br(),
  awesomeRadio(
    inputId = "id2", label = "Make a choice:",
    choices = c("base", "dplyr", "data.table"),
    inline = TRUE, status = "danger"
  ),
  verbatimTextOutput(outputId = "res2")
)

server <- function(input, output, session) {

  output$res1 <- renderPrint({
    input$id1
  })

  output$res2 <- renderPrint({
    input$id2
  })

}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link{updateAwesomeRadio}}
}
