% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim.R
\name{startAnim}
\alias{startAnim}
\title{Start an animation}
\usage{
startAnim(session, id, type = NULL)
}
\arguments{
\item{session}{The session object passed to function given to shinyServer.}

\item{id}{the id of the UI element for which you want to add animation.}

\item{type}{The type of animation to use, valid values correspond to the types in \url{https://daneden.github.io/animate.css/}}
}
\description{
Start an animation of the UI element.
}
\examples{
if(interactive()){
library(shiny)
library(shinyanimate)
ui <- fluidPage(
 withAnim(),
 tags$div(id = 'title', h1('ANIMATION')),
 actionButton(inputId = "button", label = "Animate")
)
server <- function(input, output, session){
 observeEvent(input$button,{
   startAnim(session, 'title', 'bounce')
 })
}
shinyApp(ui, server)
}
}
\seealso{
\code{\link{withAnim}}
}
