% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress_js.R
\name{progress}
\alias{progress}
\alias{progress_line}
\alias{progress_circle}
\alias{progress_semicircle}
\alias{update_progress}
\title{Create progress indicator}
\usage{
progress_line(
  value = 0,
  color = "#112446",
  stroke_width = 4,
  easing = "linear",
  duration = 1000,
  trail_color = "#eee",
  trail_width = 1,
  text = "auto",
  text_color = "#000",
  width = "100\%",
  height = "15px",
  shiny_id = NULL
)

progress_circle(
  value = 0,
  color = "#112446",
  stroke_width = 4,
  easing = "easeInOut",
  duration = 1400,
  trail_color = "#eee",
  trail_width = 1,
  text = "auto",
  text_color = "#000",
  width = "200px",
  height = "200px",
  shiny_id = NULL
)

progress_semicircle(
  value = 0,
  color = "#112446",
  stroke_width = 4,
  easing = "easeInOut",
  duration = 1400,
  trail_color = "#eee",
  trail_width = 1,
  text = "auto",
  text_color = "#000",
  width = "200px",
  height = "100px",
  shiny_id = NULL
)

update_progress(
  shiny_id,
  value,
  text = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{value}{Initial value or new value to set.}

\item{color}{Main color.}

\item{stroke_width}{Main width.}

\item{easing}{CSS animation to use, ex.: \code{"linear"},
\code{"easeIn"}, \code{"easeOut"}, \code{"easeInOut"}.}

\item{duration}{Animation duration (in milliseconds).}

\item{trail_color}{Color of shape behind the main bar.}

\item{trail_width}{Width of shape behind the main bar.}

\item{text}{Text to display.}

\item{text_color}{Text color.}

\item{width}{Container width.}

\item{height}{Container height.}

\item{shiny_id}{Id to use in Shiny application.}

\item{session}{Shiny session.}
}
\value{
an \code{htmlwidget} object.
}
\description{
Bar, circle or semicircle to show progress.
Can be used outside Shiny. In Shiny you can set
progress value server-side.
}
\examples{
# Default usage
progress_line(value = 0.5)

# change color
progress_line(value = 0.5, color = "firebrick")

# Circle
progress_circle(value = 0.5)


# Shiny usage
if (interactive()) {
  library(shiny)
  library(shinybusy)

  ui <- fluidPage(
    tags$h2("Progress bars examples"),
    fluidRow(
      column(
        width = 4,
        tags$p("Default bar:"),
        progress_line(value = 0, shiny_id = "bar"),
        sliderInput(
          inputId = "update_bar",
          label = "Update:",
          min = 0, max = 1,
          value = 0, step = 0.1
        ),
        tags$p("Set custom text:"),
        progress_line(
          value = 0.5,
          text = "To update",
          shiny_id = "text"
        ),
        textInput(
          inputId = "update_text",
          label = "Update:"
        )
      ),
      column(
        width = 4,
        tags$p("Default circle:"),
        progress_circle(value = 0, shiny_id = "circle"),
        sliderInput(
          inputId = "update_circle",
          label = "Update:",
          min = 0, max = 1,
          value = 0, step = 0.1,
          width = "100\%"
        )
      ),
      column(
        width = 4,
        tags$p("Default semi-circle:"),
        progress_semicircle(value = 0, shiny_id = "semicircle"),
        sliderInput(
          inputId = "update_semicircle",
          label = "Update:",
          min = 0, max = 1,
          value = 0, step = 0.1,
          width = "100\%"
        )
      )
    )
  )

  server <- function(input, output, session) {

    observe({
      update_progress("bar", input$update_bar)
    })

    observe({
      update_progress("circle", input$update_circle)
    })

    observe({
      update_progress("semicircle", input$update_semicircle)
    })

    observe({
      req(input$update_text)
      update_progress("text", 0.5, input$update_text)
    })

  }

  shinyApp(ui, server)
}
}
