% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draggableModalDialog.R
\name{draggableModalDialog}
\alias{draggableModalDialog}
\title{Create a draggable modal dialog UI}
\usage{
draggableModalDialog(..., title = NULL,
  footer = shiny::modalButton("Dismiss"), size = c("m", "s", "l"),
  easyClose = FALSE, fade = TRUE)
}
\arguments{
\item{...}{UI elements for the body of the modal dialog box.}

\item{title}{An optional title for the dialog.}

\item{footer}{UI for footer. Use \code{NULL} for no footer.}

\item{size}{One of \code{"s"} for small, \code{"m"} (the default) for medium,
or \code{"l"} for large.}

\item{easyClose}{If \code{TRUE}, the modal dialog can be dismissed by
clicking outside the dialog box, or be pressing the Escape key. If
\code{FALSE} (the default), the modal dialog can't be dismissed in those
ways; instead it must be dismissed by clicking on the dismiss button, or
from a call to \code{\link{removeModal}} on the server.}

\item{fade}{If \code{FALSE}, the modal dialog will have no fade-in animation
(it will simply appear rather than fade in to view).}
}
\value{
A modified shiny modal dialog UI with its content draggable.
}
\description{
This creates the UI for a modal dialog similar to \link[shiny:modalDialog]{shiny::modalDialog} except
its content is draggable.
}
