% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_quantity.R
\name{generate_quantity}
\alias{generate_quantity}
\title{Add to shinystan object a new parameter as a function of one or two 
existing parameters}
\usage{
generate_quantity(sso, param1, param2, fun, new_name)
}
\arguments{
\item{sso}{shinystan object.}

\item{param1}{Name of first parameter as character string.}

\item{param2}{Optional. Name of second paramter as character string.}

\item{fun}{Function to call, i.e. \code{function(param1)} or
\code{function(param1,param2)}. See \strong{Examples}, below.}

\item{new_name}{Name for the new parameter as character string.}
}
\value{
sso, updated. See Examples.
}
\description{
Add to shinystan object a new parameter as a function of one or two 
existing parameters
}
\examples{
\dontrun{
#################
### Example 1 ###
#################

# Below, assume X is a shinystan object and two of the
# parameters are alpha and beta.

# Add parameter gamma = inverse-logit(beta) to X
inv_logit <- function(x) 1/(exp(-x) + 1)
X <- generate_quantity(sso = X,
                       fun = inv_logit,
                       param1 = "beta",
                       new_name = "gamma")


# Add parameter delta = (alpha-beta)^2 to X
X <- generate_quantity(sso = X,
                       fun = function(x,y) (x-y)^2,
                       param1 = "alpha",
                       param2 = "beta",
                       new_name = "delta")

launch_shinystan(X)
}
}
\seealso{
\code{\link{as.shinystan}}
}

