% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_parameters.R
\name{drop_parameters}
\alias{drop_parameters}
\title{Drop parameters from a shinystan object}
\usage{
drop_parameters(sso, pars)
}
\arguments{
\item{sso}{A \code{\link[=as.shinystan]{shinystan object}}.}

\item{pars}{A character vector of parameter names. If the name of a 
non-scalar (e.g. vector, matrix) parameter is included in \code{pars} all 
of its elements will be removed. Currently it is not possible to remove 
only a subset of the elements of a non-scalar parameter.}
}
\value{
\code{sso}, with \code{pars} dropped.
}
\description{
Remove selected parameters from a shinystan object. This is useful if you 
have a very large shinystan object when you only want to look at a subset of 
parameters. With a smaller shinystan object, \code{\link{launch_shinystan}} 
will be faster and you should experience better performance (responsiveness) 
after launching when using the ShinyStan app.
}
\examples{
# Using example shinystan object 'eight_schools'
print(eight_schools@param_names)

# Remove the scalar parameters mu and tau
sso <- drop_parameters(eight_schools, pars = c("mu", "tau"))
print(sso@param_names)

# Remove all elements of the parameter vector theta
sso <- drop_parameters(sso, pars = "theta")
print(sso@param_names)

}
\seealso{
\code{\link{generate_quantity}} to add a new quantity to a shinystan
  object.
}

