% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVP_methods.R
\name{residuals.shrinkTVP}
\alias{residuals.shrinkTVP}
\title{Calculate residuals for an estimated TVP model}
\usage{
\method{residuals}{shrinkTVP}(object, ...)
}
\arguments{
\item{object}{a \code{shrinkTVP} object.}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{shrinkTVP_resid}
}
\description{
Calculates the residuals for an estimated TVP model, i.e. \eqn{y_t - X_t'\beta_t}.
}
\examples{
\donttest{

# Generate synthetic data
sim <- simTVP(N = 300)

# Estimate a model
res <- shrinkTVP(y ~ x1 + x2, sim$data)

# Calculate residuals
resids <- residuals(res)

# Visualize
plot(resids)
}
}
\seealso{
Other prediction functions: 
\code{\link{LPDS}()},
\code{\link{eval_pred_dens}()},
\code{\link{fitted.shrinkTVP}()},
\code{\link{forecast_shrinkTVP}()},
\code{\link{predict.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
