% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVPVAR_methods.R
\name{forecast_shrinkTVPVAR}
\alias{forecast_shrinkTVPVAR}
\title{Draw from posterior predictive density of a fitted TVP-VAR-SV model}
\usage{
forecast_shrinkTVPVAR(mod, n.ahead = 1)
}
\arguments{
\item{mod}{an object of class \code{shrinkTVPVAR}, containing the fitted model.}

\item{n.ahead}{a single, positive integer indicating the forecasting horizon, i.e. how many time-points into the future
the posterior predictive distribution should be sampled from. Can not be larger than the number of rows in \code{newdata}.}
}
\value{
The value returned is a list object of class \code{shrinkTVPVAR_forc} containing the samples from the
posterior predictive density.
}
\description{
\code{forecast_shrinkTVPVAR} draws from the posterior predictive distribution of a fitted TVP-VAR-SV model resulting from a call to
\code{shrinkTVPVAR}.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVPVAR(p = 2)
data <- sim$data

res <- shrinkTVPVAR(data, p = 2)
forc <- forecast_shrinkTVPVAR(res, n.ahead = 4)

# Visualize forecast
plot(forc)
}

}
\seealso{
Other prediction functions: 
\code{\link{fitted.shrinkTVPVAR}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
