% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_cn_components.R
\name{show_cn_components}
\alias{show_cn_components}
\title{Show Copy Number Components}
\usage{
show_cn_components(
  parameters,
  method = "Wang",
  show_weights = TRUE,
  log_y = FALSE,
  return_plotlist = FALSE,
  base_size = 12,
  nrow = 2,
  align = "hv",
  ...
)
}
\arguments{
\item{parameters}{a \code{data.frame} contain parameter components, obtain this
from \link{sig_tally} function.}

\item{method}{method for feature classification, can be one of
"Wang" ("W"), "S" (for method described in Steele et al. 2019).}

\item{show_weights}{default is \code{TRUE}, show weights for each component.
Only used when method is "Macintyre".}

\item{log_y}{logical, if \code{TRUE}, show \code{log10} based y axis, only
works for input from "Wang" ("W") method.}

\item{return_plotlist}{if \code{TRUE}, return a list of ggplot objects but a combined plot.}

\item{base_size}{overall font size.}

\item{nrow}{(optional) Number of rows in the plot grid.}

\item{align}{(optional) Specifies whether graphs in the grid should be horizontally ("h") or
vertically ("v") aligned. Options are "none" (default), "hv" (align in both directions), "h", and "v".}

\item{...}{other options pass to \code{\link[cowplot]{plot_grid}} function of \strong{cowplot} package.}
}
\value{
a \code{ggplot} object
}
\description{
Show classified components ("Wang" ("W") method) for copy number data.
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
