% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{output_sig}
\alias{output_sig}
\title{Output Signature Results}
\usage{
output_sig(sig, result_dir, mut_type = "SBS", sig_db = mut_type)
}
\arguments{
\item{sig}{a \code{Signature} object.}

\item{result_dir}{a result directory.}

\item{mut_type}{one of 'SBS', 'DBS', 'ID' or 'CN'.}

\item{sig_db}{default 'legacy', it can be 'legacy' (for \href{https://cancer.sanger.ac.uk/cosmic/signatures_v2.tt/}{COSMIC v2 'SBS'}),
'SBS', 'DBS', 'ID' and 'TSB' (for \href{https://cancer.sanger.ac.uk/cosmic/signatures/}{COSMIV v3.1 signatures})
for small scale mutations.
For more specific details, it can also be 'SBS_hg19', 'SBS_hg38',
'SBS_mm9', 'SBS_mm10', 'DBS_hg19', 'DBS_hg38', 'DBS_mm9', 'DBS_mm10' to use
COSMIC v3 reference signatures from Alexandrov, Ludmil B., et al. (2020) (reference #1).
In addition, it can be one of "SBS_Nik_lab_Organ", "RS_Nik_lab_Organ",
"SBS_Nik_lab", "RS_Nik_lab" to refer reference signatures from
Degasperi, Andrea, et al. (2020) (reference #2);
"RS_BRCA560", "RS_USARC" to reference signatures from BRCA560 and USARC cohorts;
"CNS_USARC" (40 categories), "CNS_TCGA" (48 categories) to reference copy number signatures from USARC cohort and TCGA.
\strong{UPDATE}, the latest version of reference version can be automatically
downloaded and loaded from \url{https://cancer.sanger.ac.uk/signatures/downloads/}
when a option with \code{latest_} prefix is specified (e.g. "latest_SBS_GRCh37").
\strong{Note}: the signature profile for different genome builds are basically same.
And specific database (e.g. 'SBS_mm10') contains less signatures than all COSMIC
signatures (because some signatures are not detected from Alexandrov, Ludmil B., et al. (2020)).
For all available options, check the parameter setting.}
}
\value{
Nothing.
}
\description{
Output Signature Results
}
