% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_signalHsmm.R
\name{run_signalHsmm}
\alias{run_signalHsmm}
\title{Predict presence of signal peptide in protein}
\usage{
run_signalHsmm(test_data)
}
\arguments{
\item{test_data}{single protein sequence (\code{character} vector) or list of 
sequences. It may be an object of class \code{\link[seqinr]{SeqFastaAA}}.}
}
\value{
An object of class \code{hsmm_pred_list}.
}
\description{
Using the hidden semi-Markov model predict presence of signal peptide in 
eukaryotic proteins.
}
\details{
Function \code{signalHsmm} returns respectively probability of presence of 
signal peptide, start of signal peptide and the probable cleavage site localization.
If input consists of more than one sequence, result is a data.frame where each column
contains above values for different proteins.
}
\note{
Currently start of signal peptide is naively set as 1 amino acid. The prediction 
of a cleavage site is still an experimental feature, use on your own risk.
}
\examples{
#run signalHsmm on one sequence
x1 <- run_signalHsmm(benchmark_dat[[1]])

#run signalHsmm on one sequence, but input is a character vector
x2 <- run_signalHsmm(c("M", "A", "G", "K", "E", "V", "I", "F", "I", "M", "A", "L", 
"F", "I", "A", "V", "E", "S", "S", "P", "I", "F", "S", "F", "D", 
"D", "L", "V", "C", "P", "S", "V", "T", "S", "L", "R", "V", "N", 
"V", "E", "K", "N", "E", "C", "S", "T", "K", "K", "D", "C", "G", 
"R", "N", "L", "C", "C", "E", "N", "Q", "N", "K", "I", "N", "V", 
"C", "V", "G", "G", "I", "M", "P", "L", "P", "K", "P", "N", "L", 
"D", "V", "N", "N", "I", "G", "G", "A", "V", "S", "E", "S", "V", 
"K", "Q", "K", "R", "E", "T", "A", "E", "S", "L"))

#run signalHsmm on list of sequences
x3 <- run_signalHsmm(benchmark_dat[1:3])
#see summary of results
summary(x3)
#print results as data frame
pred2df(x3)
#summary one result
summary(x3[[1]])
plot(x3[[1]])
}
\seealso{
\code{\link{hsmm_pred_list}} \code{\link{hsmm_pred}}
}
\keyword{classif}

