% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FTest.R
\name{wrapFTest.lm}
\alias{wrapFTest.lm}
\title{Wrap quality statistic of a linear regression.}
\usage{
\method{wrapFTest}{lm}(x, ..., format, pLargeCutoff = 0.05,
  pSmallCutoff = 1e-05)
}
\arguments{
\item{x}{lm model}

\item{...}{extra arguments (not used)}

\item{format}{if set the format to return ("html", "latex", "markdown", "ascii", "docx", ...)}

\item{pLargeCutoff}{value to declare non-significance at or above.}

\item{pSmallCutoff}{smallest value to print}
}
\value{
formatted string
}
\description{
Wrap quality statistic of a linear regression.
}
\examples{

d <- data.frame(x=c(1,2,3,4,5,6,7,7),
                y=c(1,1,2,2,3,3,4,4))
model <- lm(y~x,data=d)
summary(model)
sigr::wrapFTest(model)


}

