% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simLife.R
\name{simTimes}
\alias{simTimes}
\title{Crack time simulation}
\usage{
simTimes(S, param, vickers, stress, verbose = FALSE,
  parallel.option = getOption("parallel.option", "lapply"))
}
\arguments{
\item{S}{(non-overlapping) geometry system}

\item{param}{parameters for generating failure times}

\item{vickers}{vickers hardness}

\item{stress}{stress level}

\item{verbose}{logical: ignored}

\item{parallel.option}{optional: In case of \code{mclapply} the function 
\code{mclapply} is used from the parallel package}
}
\value{
list of increasing failure times
}
\description{
Simulate crack times of particles
}
\details{
The function randomly generates phase dependent failure times of defect types \code{crack} and \code{delam}.
The accumulation structure of defects is initialized containing the failure times of objects in ascending order.
The failure times of the defect type \code{crack} follow a Weibull distribution, see \code{\link{simCrackTime}}.
The failure times of the defect type \code{delam} roughly depend on the projected area of the object, the 
applied overall stress amplitude and whether the object lies in the interior of the simulation box or hits
one of the box boundaries. The argument \code{param} consists of a distribution parameter list which contains 
numeric vectors for both reinforcement objects (labled by \code{P}) and an optional second phase (labled by \code{F}).
If no second phase is considered the corresponding parameter set is simply ignored. Each parameter vector is made up of
six parameters in the following order: \eqn{p1} probability of already materialized defects, scale factor \eqn{p2},
shape factor \eqn{p3}, shift parameter \eqn{p4} of log times, the slope \eqn{p5} and \eqn{p6} as the standard deviation
of the random error of log times.
}
\examples{
## Simulation of individual defect times	
data(AL2MC_20p_k10_F2p_S)
data(AL2MC_20p_k10_F2p_CL)

## generate individual failure times
opt <- list("vickers"=107,"distTol"=0.001,
			"inAreafactor"=1.56, "outAreafactor"=1.43, 
			"pointsConvHull"=10, "scale"=1e+06,"pl"=0)	

## simulation parameter	
par <- list("P"=c(0.01,10^12,10,108,-14,0.01),
			"F"=c(0.01,10^10,10,100,-13,0.01))	

## simulate times	
CLT <- simTimes(S,par,vickers=opt$vickers,stress=125)

## times
T <- unlist(sapply(CLT,`[[`,"T"))
V <- unlist(sapply(CLT,`[[`,"V"))
U <- unlist(sapply(CLT,`[[`,"U"))

## show estimated densities
multi.density.plot(list("Delamination"=log10(V),"Crack"=log10(U),"Time"=log10(T)))

}
\seealso{
\code{\link{getCrackTime}}, \code{\link{getDelamTime}}
}

