% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0classes.R
\name{manageSimPopObj}
\alias{manageSimPopObj}
\title{get and set variables from population or sample data stored in an object of
class \code{\linkS4class{simPopObj}}.}
\usage{
manageSimPopObj(x, var, sample = FALSE, set = FALSE, values = NULL)
}
\arguments{
\item{x}{an object of class \code{\linkS4class{simPopObj}}.}

\item{var}{character vector of length 1; variable name that should be set or
extracted.}

\item{sample}{a logical indicating whether \code{var} should be
extracted/set from slot 'sample' (TRUE) or slot 'pop' (FALSE).}

\item{set}{logical; if TRUE, argument 'values' is set to either the sample
or population data stored in 'x', depending on argument 'sample'. If FALSE,
the desired variable given by 'var' is returned from either the sample or
the pop slot of 'x'.}

\item{values}{vector; if 'set' is TRUE, then this vector is used to update
the variable of sample or population data depending of choice of argument
'sample'.}
}
\value{
An object of class \code{\linkS4class{simPopObj}} (if 'set' is TRUE)
or a vector (if 'set' is FALSE).
}
\description{
This functions allows to get or set variables in slots \code{pop} and
\code{sample} of \code{\linkS4class{simPopObj}}-objects. This is a utility
function that is useful for writing custom wrapper functions.
}
\examples{
data(eusilcS)
inp <- specifyInput(data=eusilcS, hhid="db030", hhsize="hsize", strata="db040",
  weight="db090")
simPopObj <- simStructure(data=inp, method="direct", basicHHvars=c("age", "rb090"))

(manageSimPopObj(simPopObj, var="age", sample=FALSE, set=FALSE))
(manageSimPopObj(simPopObj, var="age", sample=TRUE, set=FALSE))
}
\author{
Bernhard Meindl and Matthias Templ
}
\keyword{manip}
