% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimAlphaN}
\alias{SimAlphaN}
\title{Simulate Intercept Vectors
in a Discrete-Time Vector Autoregressive Model
from the Multivariate Normal Distribution}
\usage{
SimAlphaN(n, alpha, vcov_alpha_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{alpha}{Numeric vector.
Intercept (\eqn{\boldsymbol{\alpha}}).}

\item{vcov_alpha_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_alpha))})
of the sampling variance-covariance matrix of
\eqn{\boldsymbol{\alpha}}.}
}
\value{
Returns a list of random intercept vectors.
}
\description{
This function simulates random intercept vectors
in a discrete-time vector autoregressive model
from the multivariate normal distribution.
}
\examples{
n <- 10
alpha <- c(0, 0, 0)
vcov_alpha_l <- t(chol(0.001 * diag(3)))
SimAlphaN(n = n, alpha = alpha, vcov_alpha_l = vcov_alpha_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
